<?php

namespace App\Http\Models;

use Illuminate\Database\Eloquent\Model;
use \WP_Query;

class Post extends Model
{

    public $id;
    public $title;
    public $gallery;
    public $content;
    public $date;

    public function __construct($post_id = null)
    {
        $post_id = $post_id ?: get_the_ID();
        $this->gallery = get_field('gallery', $post_id);
        $this->title = get_the_title($post_id);
        $this->content = get_the_content(null, false, $post_id);
        $this->date = get_the_date( 'j F Y', $post_id );
    }

    public static function get_posts($post_ids = null) {
        $posts = [];

        $args = [
            'post_type' => 'post',
            'posts_per_page' => -1,
            'post_status' => 'publish',
            'orderby' => 'post__in',
            'order' => 'ASC',
            'post__in' => $post_ids
        ];

        $query = new WP_Query($args);

        foreach ($query->posts as $post_id) {
            $posts[] = new static($post_id);
        }

        return $posts;
    }
}

?>